#!/bin/bash

PARAMS0=$*
PARAMS=${PARAMS0//=/ }
set -- $PARAMS

VERSION=2.1
WITH_PGSQL=
WITH_PGPOOL=
WITH_OCF=

while true; do
  case "$1" in
   --help ) echo "options:"
	echo " --with-pgsql  PostgreSQL install path"
	echo " --with-pgpool pgpool install path"
	echo " --with-ocf    OCF RA files path"
	exit ;;
   --with-pgsql )  WITH_PGSQL_DIR=$2  ; shift 2 ;;
   --with-pgpool ) WITH_PGPOOL_DIR=$2 ; shift 2 ;;
   --with-ocf    ) WITH_OCF_DIR=$2    ; shift 2 ;;
   -- ) shift; break ;;
   "" ) shift; break ;;
   * ) echo "invalid parameter: $1" ; exit ;;
  esac
done

if [ "x${WITH_PGSQL_DIR}" = "x" ]; then
	WITH_PGSQL_DIR=/usr/local/pgsql
fi
if [ "x${WITH_PGPOOL_DIR}" = "x" ]; then
	WITH_PGPOOL_DIR=/usr/local
fi
if [ "x${WITH_OCF_DIR}" = "x" ]; then
	WITH_OCF_DIR=/usr/lib/ocf/resource.d/heartbeat
fi
INSTALL=`type -p install`

if [ ! -d $WITH_PGSQL_DIR ]; then
	echo "PostgreSQL directory ($WITH_PGSQL_DIR) not found."
	# (warning only)
fi
if [ ! -f $WITH_PGPOOL_DIR/bin/pgpool ]; then
	echo "Pgpool directory ($WITH_PGPOOL_DIR) not found."
	# (warning only)
fi
if [ ! -d $WITH_OCF_DIR ]; then
	echo "OCF RA directory ($WITH_OCF_DIR) not found."
	exit 1
fi
if [ "x$INSTALL" = "x" ]; then
	echo "no install command."
	exit 1
fi

echo "PGSQL_DIR: $WITH_PGSQL_DIR"
echo "PGPOOL_DIR: $WITH_PGPOOL_DIR"
echo "OCF_DIR: $WITH_OCF_DIR"

sed -e "s#@PGSQL_DIR@#${WITH_PGSQL_DIR}#g" < Makefile.in | \
	sed -e "s#@PGPOOL_DIR@#${WITH_PGPOOL_DIR}#g" | \
	sed -e "s#@OCF_DIR@#${WITH_OCF_DIR}#g" | \
	sed -e "s#@INSTALL@#${INSTALL}#g" | \
	sed -e "s#@VERSION@#${VERSION}#g" > Makefile

echo "Makefile generated"
echo $0 $PARAMS0 > config.log

