/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"indent\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_object\0"
	"json_objectagg\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"pgpool\0"
	"placing\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"system_user\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	519,
	528,
	539,
	550,
	562,
	570,
	579,
	590,
	595,
	600,
	607,
	613,
	617,
	622,
	630,
	646,
	659,
	672,
	687,
	700,
	718,
	731,
	738,
	744,
	749,
	758,
	762,
	773,
	777,
	785,
	793,
	801,
	810,
	821,
	830,
	838,
	845,
	855,
	866,
	874,
	880,
	885,
	892,
	903,
	911,
	919,
	928,
	931,
	940,
	947,
	954,
	959,
	964,
	969,
	976,
	985,
	995,
	999,
	1004,
	1011,
	1017,
	1024,
	1032,
	1042,
	1052,
	1060,
	1067,
	1075,
	1086,
	1096,
	1105,
	1113,
	1119,
	1126,
	1132,
	1139,
	1148,
	1154,
	1160,
	1170,
	1174,
	1180,
	1188,
	1195,
	1203,
	1210,
	1215,
	1220,
	1229,
	1239,
	1249,
	1256,
	1262,
	1270,
	1279,
	1285,
	1294,
	1301,
	1309,
	1316,
	1323,
	1328,
	1333,
	1342,
	1345,
	1351,
	1361,
	1371,
	1380,
	1387,
	1390,
	1398,
	1408,
	1418,
	1425,
	1431,
	1439,
	1447,
	1456,
	1466,
	1473,
	1479,
	1485,
	1491,
	1503,
	1510,
	1518,
	1522,
	1530,
	1540,
	1549,
	1554,
	1562,
	1565,
	1572,
	1582,
	1587,
	1592,
	1603,
	1617,
	1629,
	1644,
	1648,
	1653,
	1659,
	1668,
	1674,
	1679,
	1687,
	1695,
	1705,
	1711,
	1716,
	1722,
	1727,
	1733,
	1740,
	1745,
	1751,
	1761,
	1776,
	1785,
	1790,
	1797,
	1804,
	1812,
	1818,
	1826,
	1839,
	1848,
	1854,
	1861,
	1868,
	1877,
	1882,
	1888,
	1893,
	1898,
	1904,
	1913,
	1921,
	1927,
	1931,
	1936,
	1940,
	1944,
	1949,
	1954,
	1957,
	1962,
	1972,
	1983,
	1987,
	1995,
	2002,
	2010,
	2017,
	2022,
	2029,
	2035,
	2043,
	2050,
	2053,
	2057,
	2064,
	2069,
	2073,
	2076,
	2081,
	2090,
	2097,
	2105,
	2108,
	2114,
	2125,
	2132,
	2136,
	2142,
	2147,
	2156,
	2164,
	2175,
	2181,
	2187,
	2196,
	2206,
	2213,
	2221,
	2231,
	2239,
	2248,
	2255,
	2263,
	2269,
	2276,
	2285,
	2295,
	2305,
	2313,
	2322,
	2331,
	2339,
	2345,
	2356,
	2367,
	2377,
	2388,
	2396,
	2408,
	2414,
	2420,
	2425,
	2430,
	2439,
	2447,
	2457,
	2461,
	2472,
	2484,
	2492,
	2500,
	2509,
	2517,
	2524,
	2535,
	2543,
	2551,
	2557,
	2565,
	2574,
	2581,
	2591,
	2599,
	2606,
	2612,
	2617,
	2626,
	2633,
	2641,
	2650,
	2654,
	2659,
	2664,
	2674,
	2681,
	2688,
	2696,
	2703,
	2710,
	2717,
	2726,
	2733,
	2742,
	2752,
	2765,
	2772,
	2780,
	2793,
	2797,
	2803,
	2808,
	2814,
	2819,
	2827,
	2834,
	2839,
	2848,
	2857,
	2862,
	2866,
	2873,
	2884,
	2890,
	2900,
	2911,
	2917,
	2924,
	2932,
	2939,
	2946,
	2952,
	2965,
	2975,
	2983,
	2993,
	2999,
	3006,
	3018,
	3024,
	3031,
	3043,
	3054,
	3059,
	3068,
	3078,
	3083,
	3088,
	3093,
	3098,
	3108,
	3111,
	3120,
	3132,
	3142,
	3148,
	3156,
	3161,
	3166,
	3175,
	3183,
	3188,
	3194,
	3202,
	3212,
	3224,
	3236,
	3242,
	3249,
	3257,
	3266,
	3275,
	3281,
	3288,
	3293,
	3299,
	3306,
	3312,
	3321,
	3331,
	3337,
	3344,
	3352,
	3361,
	3369,
	3377,
	3385,
	3390,
	3396,
	3405,
	3410,
	3416,
	3427,
	3434,
	3439,
	3446,
	3454,
	3459,
	3467,
	3473,
	3477,
	3491,
	3501,
	3512,
	3522,
	3532,
	3546,
	3555,
	3561,
	3569,
	3582,
	3591,
	3596,
	3600,
};

#define SCANKEYWORDS_NUM_KEYWORDS 472

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[945] = {
		144,   0,     32767, -20,   -69,   -122,  566,   32767,
		213,   0,     411,   32767, -82,   32767, 378,   -161,
		394,   233,   4,     32767, 32767, 32767, 32767, -91,
		32767, 32767, 0,     32767, 70,    32767, 32767, 0,
		203,   32767, 32767, 401,   32767, -230,  32767, 32767,
		983,   803,   32767, 348,   -285,  257,   422,   32767,
		-82,   540,   -251,  32767, 32767, 32767, 32767, 32767,
		-591,  32767, 428,   57,    32767, 32767, 32767, 32767,
		0,     0,     66,    -57,   32767, 0,     22,    -214,
		32767, 0,     -107,  32767, 49,    -25,   32767, 32767,
		32767, 200,   32767, 334,   -287,  268,   247,   32767,
		0,     460,   32767, 211,   0,     214,   275,   34,
		0,     -3,    0,     32767, 32767, 232,   -118,  249,
		355,   732,   32767, 32767, -46,   32767, 353,   -193,
		9,     0,     32767, 0,     207,   32767, 32767, 98,
		32767, 44,    -43,   0,     334,   235,   499,   -1,
		-156,  157,   16,    341,   625,   32767, 32767, 61,
		32767, -134,  32767, -233,  -366,  32767, 32767, -16,
		-444,  32767, 32767, 86,    32767, 32767, 303,   101,
		0,     32767, 337,   214,   181,   -82,   -261,  0,
		32767, 0,     32767, 438,   32767, 32767, 389,   32767,
		642,   363,   444,   417,   32767, 32767, 0,     32767,
		365,   211,   396,   458,   -241,  -40,   -407,  32767,
		118,   32767, 32767, -39,   -137,  159,   32767, 40,
		234,   626,   56,    70,    32767, 56,    43,    32767,
		19,    404,   0,     32767, 156,   240,   9,     405,
		0,     24,    32767, -46,   0,     0,     24,    468,
		32767, 419,   517,   6,     93,    -269,  0,     204,
		-174,  32767, 32767, 32767, 227,   119,   0,     32767,
		32767, 32767, 217,   32767, 32767, 321,   0,     -124,
		-57,   32767, 162,   32767, 89,    421,   534,   -663,
		32767, 0,     32767, 624,   32767, 375,   261,   0,
		294,   287,   -157,  32767, 32767, 0,     32767, 32,
		0,     235,   281,   236,   32767, -369,  32767, 32767,
		32767, 206,   32767, -120,  32767, 32767, 343,   270,
		-152,  376,   877,   366,   196,   338,   -124,  275,
		-81,   -147,  0,     280,   455,   0,     467,   32767,
		115,   -26,   32767, 32767, 32767, 32767, 88,    32767,
		32767, 32767, 32767, 337,   32767, 311,   32767, 0,
		32767, 32767, 32767, 32767, -256,  32767, 32767, 32767,
		287,   32767, 32767, -198,  18,    32767, 0,     367,
		32767, 0,     80,    32767, 32767, 244,   334,   32767,
		3,     68,    32767, 32767, -173,  29,    638,   32767,
		32767, 650,   1,     0,     0,     0,     319,   32767,
		32767, 32767, 0,     336,   -30,   418,   320,   32767,
		32767, 32767, 32767, 101,   117,   32767, 32767, 0,
		-176,  -211,  -58,   78,    276,   32767, 32767, 352,
		0,     -236,  32767, -147,  32767, 109,   65,    562,
		295,   32767, 32767, 370,   154,   77,    32767, 32767,
		32767, -16,   0,     -156,  391,   32767, 32767, 70,
		32767, 374,   -87,   189,   395,   -214,  32767, 67,
		32767, 465,   327,   211,   32767, 32767, 0,     -18,
		291,   32767, -90,   32767, 32767, 32767, 352,   32767,
		396,   -48,   0,     32767, 377,   161,   14,    32767,
		362,   32767, -342,  32767, -315,  32767, 32767, 294,
		-202,  32767, 0,     401,   222,   241,   28,    253,
		-132,  343,   32767, 372,   128,   32767, 212,   32767,
		269,   32767, 32767, -345,  1,     32767, 0,     0,
		249,   32767, 244,   0,     32767, 188,   54,    131,
		-81,   -75,   18,    0,     32767, 32767, 32767, 0,
		226,   32767, 89,    32767, 32767, 251,   0,     32767,
		215,   380,   52,    32767, 89,    -105,  32767, 362,
		32767, 51,    32767, 32767, 32767, 446,   364,   19,
		103,   32767, 32767, -69,   6,     57,    32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, -29,   32767,
		218,   36,    32767, 367,   377,   32767, 152,   1,
		32767, 0,     32767, 0,     32767, 66,    32767, 32767,
		139,   0,     -52,   32767, -306,  0,     110,   186,
		0,     -18,   419,   134,   316,   27,    470,   1,
		32767, 0,     0,     32767, 32767, -103,  237,   32767,
		32767, 760,   173,   0,     107,   32767, 208,   0,
		168,   735,   32767, 32767, 211,   212,   32767, 32767,
		0,     32767, 604,   32767, 196,   32767, 569,   32767,
		32767, -24,   21,    32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 0,     -146,  -151,  32767,
		277,   32767, 251,   385,   -99,   32767, 32767, 155,
		140,   32767, -213,  -292,  -51,   0,     0,     82,
		117,   -385,  300,   0,     145,   577,   0,     -21,
		32767, -215,  32767, -195,  -148,  -100,  54,    31,
		0,     32767, 32767, 178,   32767, 32767, 32767, 16,
		62,    397,   -158,  0,     0,     216,   299,   32767,
		384,   32767, 31,    0,     32767, 32767, 419,   -295,
		32767, 32767, 32767, 32767, 0,     248,   32767, 32767,
		32767, 176,   107,   -559,  -221,  252,   116,   -203,
		400,   32767, 32767, 32767, -167,  0,     84,    -68,
		0,     32767, 0,     57,    382,   32767, 213,   32767,
		330,   0,     296,   32767, 248,   32767, 285,   0,
		702,   32767, 0,     33,    32767, 124,   32767, 32767,
		443,   32767, 0,     -128,  365,   32767, 32767, 5,
		-162,  445,   32767, 32767, 32767, 32767, 32767, 312,
		0,     32767, 83,    32767, 32767, 0,     190,   32767,
		32767, 32767, -84,   0,     32767, 451,   71,    32767,
		-192,  39,    483,   0,     282,   32767, 0,     32767,
		32767, 297,   0,     348,   307,   132,   280,   287,
		368,   199,   0,     0,     261,   61,    32767, -91,
		0,     32767, 76,    0,     501,   80,    32767, 0,
		109,   41,    167,   195,   32767, 200,   80,    152,
		-40,   32767, 0,     12,    357,   -158,  32767, 32767,
		312,   32767, 318,   32767, 104,   176,   560,   185,
		32767, 397,   187,   32767, 32767, 0,     32767, 227,
		445,   281,   32767, 32767, 379,   386,   254,   -39,
		0,     27,    0,     32767, 0,     32767, 0,     32767,
		347,   589,   0,     0,     32767, -263,  32767, 32767,
		260,   32767, 32767, 264,   32767, 32767, 0,     0,
		-361,  -175,  32767, 387,   326,   32767, 308,   32767,
		32767, 310,   32767, 32767, 32767, 32767, 32767, 30,
		0,     393,   0,     258,   256,   -324,  0,     0,
		0,     332,   556,   0,     -39,   32767, 32767, 32767,
		0,     -327,  0,     32767, 32767, 32767, 179,   32767,
		32767, 55,    283,   32767, -216,  32767, 32767, 132,
		32767, 564,   -359,  5,     32767, 0,     126,   32767,
		0,     411,   32767, 32767, 0,     304,   0,     294,
		0,     -133,  32767, 0,     32767, 32767, 32767, 153,
		37,    32767, 0,     -8,    141,   32767, 32767, 32767,
		32767, 0,     32767, 420,   32767, 169,   32767, 32767,
		32767, 97,    449,   32767, 156,   32767, 32767, 33,
		346,   32767, 271,   -46,   0,     32767, 32767, 0,
		32767, 32767, 464,   58,    32767, 205,   102,   100,
		0
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 945] + h[b % 945];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
