import java.sql.*;

public class Hoge {
	/**
	 * DB の名前。
	 */
	public static final String DB_NAME = "test";

	/**
	 * DB に接続する際のユーザー名。
	 */
	public static final String DB_USER = "yugo-n";

	/**
	 * DB に接続する際のパスワード。
	 */
	public static final String DB_PASSWORD = "";

	/**
	 * 標準出力に文字列を出力。
	 * 文字列の長さが width に満たない場合は、足りない分の空白も出力。
	 *
	 * @param str 表示する文字列
	 * @param width 表示幅
	 */
	public static void printString(String str, int width) {
		int len = 0;
		for (int i = 0; i < str.length(); ++i) {
			if ((int) str.charAt(i) < 0x100) {
				len += 1;		// たぶん半角
			} else {
				len += 2;		// たぶん全角
			}
		}
		System.out.print(str);
		for (int i = len; i < width; ++i) {
			System.out.print(" ");
		}
	}

	/**
	 *
	 * @param conn1 DB への接続
	 * @throws SQLException クエリーの実行中にエラーが発生
	 */
	public static void hoge(Connection connection) throws SQLException {
	
        connection.setAutoCommit(false);
        PreparedStatement stmt = null;
        
        try {
            try {
                //stmt = connection.prepareStatement("insert into batch2(c1,c6) values(?,?)");
                //stmt = connection.prepareStatement("insert into batch2(c1) values(?)");
                stmt = connection.prepareStatement("insert into batch2(c2) values(?)");
				for (int i = 0; i < 5; i++) {
					Object param;
					//param = 1;
					//stmt.setObject(1,param);
					param = new java.util.Date();
					stmt.setTimestamp(1, new java.sql.Timestamp(((java.util.Date)param).getTime()));
					//param = new java.util.Date();
					//stmt.setTimestamp(2, new java.sql.Timestamp(((java.util.Date)param).getTime()));
					stmt.addBatch();
				}
				stmt.executeBatch();

                connection.commit();
                stmt.close();
			} catch(SQLException e){
				while (e != null){
					System.out.println(e.getMessage());
					e=e.getNextException();
				}
            } finally {
                if(stmt != null) stmt.close();
            }
        } finally {
            connection.close();
        }
	}

	/**
	 * main メソッド。
	 *
	 * @param args コマンド行引数
	 */
	public static void main(String[] args) {
				//while(true){	
		try {
			// JDBC ドライバを読み込む。
			Class.forName("org.postgresql.Driver");

			// DB に接続する。
			Connection conn = DriverManager.getConnection(
					//"jdbc:postgresql://localhost:9999/" + DB_NAME, DB_USER, DB_PASSWORD);
					//"jdbc:postgresql://133.137.177.146:9999/" + DB_NAME, DB_USER, DB_PASSWORD);
					"jdbc:postgresql://localhost:12002/" + DB_NAME + "?user="+DB_USER+"&password="+DB_PASSWORD);
					//"jdbc:postgresql://osspc19:5432/" + DB_NAME, DB_USER, DB_PASSWORD);

			try {
				hoge(conn);
			} finally {
				conn.close();
			}
		} catch (ClassNotFoundException e) {
			// JDBC ドライバの読み込みに失敗。
			System.err.println("can't load driver");
		} catch (SQLException e) {
			// DB の接続中に例外が発生。
			System.err.println("database error : " + e);
			System.err.println(e.getSQLState());
		} finally {
				System.out.print("fin");
		}
				//}
	}
}
